package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.CloudConstants;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.common.model.Device;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

public class RegisterDeviceRequestExecutor extends RequestExecutor<Device> {

  private final String sourceId;
  private final DevicesService devicesService;

  public RegisterDeviceRequestExecutor(final DevicesService devicesService, final String sourceId) {
    this.sourceId = sourceId;
    this.devicesService = devicesService;
  }

  @Override
  protected Call<Device> prepareCall() {
    return devicesService.registerDevice(params());
  }

  @Override
  protected Map<String, String> params() {
    final Map<String, String> params = new HashMap<>();

    final String alias = "android-kontakt-gateway";
    params.put(CloudConstants.Common.UNIQUE_ID_PARAMETER, sourceId);
    params.put(CloudConstants.Devices.ALIAS_PARAMETER, alias);
    params.put(CloudConstants.Devices.PROPERTIES_PARAMETER, "");

    return params;
  }
}
