package com.kontakt.sdk.android.cloud.api.executor;

import com.kontakt.sdk.android.common.util.SDKPreconditions;

/**
 * Request executor designed for fetching requested data directly from the URL.
 *
 * @param <T> the response type.
 */
public abstract class UrlRequestExecutor<T> extends RequestExecutor<T> {

  protected final String url;
  protected String eTag;

  /**
   * Constructs request executor initialized with the URL.
   *
   * @param url the URL.
   */
  protected UrlRequestExecutor(final String url) {
    this.url = url;
  }

  /**
   * Specifies HTTP entity tag purposed for caching REST API calls.
   *
   * @param eTag the entity tag value.
   * @return this request executor.
   */
  public UrlRequestExecutor eTag(final String eTag) {
    this.eTag = SDKPreconditions.checkNotNull(eTag, "eTag cannot be null");
    return this;
  }
}
