package com.kontakt.sdk.android.cloud;

import retrofit2.Retrofit;

final class ServicesFactory {

  final Retrofit retrofit;

  public static ServicesFactory newInstance(final Retrofit retrofit) {
    return new ServicesFactory(retrofit);
  }

  private ServicesFactory(final Retrofit retrofit) {
    this.retrofit = retrofit;
  }

  <E> E createService(final Class<E> serviceToCreate) {
    return retrofit.create(serviceToCreate);
  }
}
