package com.kontakt.sdk.android.ble.security.property;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import static com.kontakt.sdk.android.ble.security.property.PropertyDataType.BYTE_ARRAY;
import static com.kontakt.sdk.android.ble.security.property.PropertyDataType.INT8;
import static com.kontakt.sdk.android.ble.security.property.PropertyDataType.NONE;
import static com.kontakt.sdk.android.ble.security.property.PropertyDataType.STRING;
import static com.kontakt.sdk.android.ble.security.property.PropertyDataType.UINT16;
import static com.kontakt.sdk.android.ble.security.property.PropertyDataType.UINT32;
import static com.kontakt.sdk.android.ble.security.property.PropertyDataType.UINT8;

import static com.kontakt.sdk.android.ble.security.property.PropertyName.CUSTOM;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.PROXIMITY_UUID;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.MAJOR;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.MINOR;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.NAME;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.BEACON_ID;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.REF_TX_1M;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.NAMESPACE_ID;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.INSTANCE_ID;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.URL;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.REF_TX_0M;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.INTERVAL;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.SET_PASSWORD;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.SHUFFLE_INTERVAL;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.ACTIVE_PROFILE;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.TX_POWER;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.EDDY_EID_SCALER;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.BEACON_PACKETS_MASK;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.POWER_SAVER_FEATURES_MASK;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.MOVE_SUSPEND_TIMEOUT;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.LIGHT_SENSOR_THRESHOLD;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.LIGHT_SENSOR_HIST;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.LIGHT_SENSOR_SAMPLING_INTERVAL;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.TEMPERATURE_OFFSET;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.WIFI_SSID;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.WIFI_USER;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.WIFI_PASS;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.WIFI_PROTOCOL;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.API_KEY;
import static com.kontakt.sdk.android.ble.security.property.PropertyName.TERMINATING;

public class PropertyID {

  public static final PropertyID PROPERTY_PROXIMITY_UUID = new PropertyID(PROXIMITY_UUID, 0x8111, BYTE_ARRAY);
  public static final PropertyID PROPERTY_MAJOR = new PropertyID(MAJOR, 0x8112, UINT16);
  public static final PropertyID PROPERTY_MINOR = new PropertyID(MINOR, 0x8113, UINT16);
  public static final PropertyID PROPERTY_NAME = new PropertyID(NAME, 0x8114, STRING);
  public static final PropertyID PROPERTY_BEACON_ID = new PropertyID(BEACON_ID, 0x8115, STRING);
  public static final PropertyID PROPERTY_REF_TX_1M = new PropertyID(REF_TX_1M, 0x8116, BYTE_ARRAY);
  public static final PropertyID PROPERTY_NAMESPACE_ID = new PropertyID(NAMESPACE_ID, 0x8117, BYTE_ARRAY);
  public static final PropertyID PROPERTY_INSTANCE_ID = new PropertyID(INSTANCE_ID, 0x8118, BYTE_ARRAY);
  public static final PropertyID PROPERTY_URL = new PropertyID(URL, 0x8119, BYTE_ARRAY);
  public static final PropertyID PROPERTY_REF_TX_0M = new PropertyID(REF_TX_0M, 0x811A, BYTE_ARRAY);
  public static final PropertyID PROPERTY_INTERVAL = new PropertyID(INTERVAL, 0x8121, UINT16);
  public static final PropertyID PROPERTY_SET_PASSWORD = new PropertyID(SET_PASSWORD, 0x8132, STRING);
  public static final PropertyID PROPERTY_SHUFFLE_INTERVAL = new PropertyID(SHUFFLE_INTERVAL, 0x8138, UINT16);
  public static final PropertyID PROPERTY_ACTIVE_PROFILE = new PropertyID(ACTIVE_PROFILE, 0x813A, UINT8);
  public static final PropertyID PROPERTY_TX_POWER = new PropertyID(TX_POWER, 0x2A07, INT8);
  public static final PropertyID PROPERTY_EDDY_EID_SCALER = new PropertyID(EDDY_EID_SCALER, 0x811c, UINT8);
  public static final PropertyID PROPERTY_BEACON_PACKETS_MASK = new PropertyID(BEACON_PACKETS_MASK, 0x811e, UINT32);
  public static final PropertyID PROPERTY_POWER_SAVER_FEATURES_MASK = new PropertyID(POWER_SAVER_FEATURES_MASK, 0x8300, UINT32);
  public static final PropertyID PROPERTY_MOVE_SUSPEND_TIMEOUT = new PropertyID(MOVE_SUSPEND_TIMEOUT, 0x8301, UINT32);
  public static final PropertyID PROPERTY_LIGHT_SENSOR_THRESHOLD = new PropertyID(LIGHT_SENSOR_THRESHOLD, 0x8302, INT8);
  public static final PropertyID PROPERTY_LIGHT_SENSOR_HIST = new PropertyID(LIGHT_SENSOR_HIST, 0x8303, INT8);
  public static final PropertyID PROPERTY_LIGHT_SENSOR_SAMPLING_INTERVAL = new PropertyID(LIGHT_SENSOR_SAMPLING_INTERVAL, 0x8304, UINT32);
  public static final PropertyID PROPERTY_TEMPERATURE_OFFSET = new PropertyID(TEMPERATURE_OFFSET, 0x9150, INT8);
  public static final PropertyID PROPERTY_WIFI_SSID = new PropertyID(WIFI_SSID, 0x8201, STRING);
  public static final PropertyID PROPERTY_WIFI_USER = new PropertyID(WIFI_USER, 0x8202, STRING);
  public static final PropertyID PROPERTY_WIFI_PASS = new PropertyID(WIFI_PASS, 0x8203, STRING);
  public static final PropertyID PROPERTY_WIFI_PROTOCOL = new PropertyID(WIFI_PROTOCOL, 0x8204, INT8);
  public static final PropertyID PROPERTY_API_KEY = new PropertyID(API_KEY, 0x8205, STRING);
  public static final PropertyID PROPERTY_TERMINATING = new PropertyID(TERMINATING, 0xFFFF, NONE);

  public static final PropertyID[] PREDEFINED_PROPERTIES = new PropertyID[] {
      PROPERTY_PROXIMITY_UUID,
      PROPERTY_MAJOR,
      PROPERTY_MINOR,
      PROPERTY_NAME,
      PROPERTY_BEACON_ID,
      PROPERTY_REF_TX_1M,
      PROPERTY_NAMESPACE_ID,
      PROPERTY_INSTANCE_ID,
      PROPERTY_URL,
      PROPERTY_REF_TX_0M,
      PROPERTY_INTERVAL,
      PROPERTY_SET_PASSWORD,
      PROPERTY_SHUFFLE_INTERVAL,
      PROPERTY_ACTIVE_PROFILE,
      PROPERTY_TX_POWER,
      PROPERTY_EDDY_EID_SCALER,
      PROPERTY_BEACON_PACKETS_MASK,
      PROPERTY_POWER_SAVER_FEATURES_MASK,
      PROPERTY_MOVE_SUSPEND_TIMEOUT,
      PROPERTY_LIGHT_SENSOR_THRESHOLD,
      PROPERTY_LIGHT_SENSOR_HIST,
      PROPERTY_LIGHT_SENSOR_SAMPLING_INTERVAL,
      PROPERTY_TEMPERATURE_OFFSET,
      PROPERTY_WIFI_SSID,
      PROPERTY_WIFI_USER,
      PROPERTY_WIFI_PASS,
      PROPERTY_WIFI_PROTOCOL,
      PROPERTY_API_KEY,
      PROPERTY_TERMINATING
  };

  // Set of custom properties manually set by client used to resolve secure config encryption in offline mode.
  private static final Set<PropertyID> customProperties = new HashSet<>();

  private final PropertyName name;
  private final short value;
  private final PropertyDataType type;

  public static PropertyID createCustom(final int value) {
    return new PropertyID(CUSTOM, value, BYTE_ARRAY);
  }

  private PropertyID(final PropertyName name, final int value, final PropertyDataType type) {
    this.name = name;
    this.type = type;
    this.value = (short) value;
  }

  public PropertyName getName() {
    return name;
  }

  public short getValue() {
    return value;
  }

  public PropertyDataType getDataType() {
    return type;
  }

  public static PropertyID get(final short value) {
    // Check predefined properties
    for (final PropertyID property : PREDEFINED_PROPERTIES) {
      if (property.getValue() == value) {
        return property;
      }
    }

    // Check custom properties
    for (final PropertyID property : customProperties) {
      if (property.getValue() == value) {
        return property;
      }
    }

    // Property not found
    return null;
  }

  public static void defineCustomProperties(final Set<PropertyID> properties) {
    if (properties == null || properties.isEmpty()) return;

    customProperties.clear();
    customProperties.addAll(properties);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    PropertyID that = (PropertyID) o;

    if (value != that.value) return false;
    if (name != that.name) return false;
    return type == that.type;
  }

  @Override
  public int hashCode() {
    int result = name != null ? name.hashCode() : 0;
    result = 31 * result + (int) value;
    result = 31 * result + (type != null ? type.hashCode() : 0);
    return result;
  }

  @Override
  public String toString() {
    return "PropertyID{" + "name=" + name + ", value=" + value + ", type=" + type + '}';
  }

}
