package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.ble.discovery.PropertyResolver;
import com.kontakt.sdk.android.common.util.ConversionUtils;

final class ETLMResolver implements PropertyResolver<String> {

  private static final int ETLM_START_INDEX = 2;
  private static final int ETLM_LENGTH = 18;

  private static final int MASK = 0x00FF;
  private static final String FORMAT = "%02x";

  private final StringBuilder stringBuilder = new StringBuilder();

  @Override
  public String parse(byte[] packet) throws IllegalArgumentException {
    if (packet == null) {
      return null;
    }

    byte[] bytes = ConversionUtils.extractSubdata(packet, ETLM_START_INDEX, ETLM_LENGTH);
    if (bytes == null) {
      return null;
    }

    stringBuilder.setLength(0);
    for (byte byteValue : bytes) {
      stringBuilder.append(String.format(FORMAT, byteValue & MASK));
    }

    return stringBuilder.toString();
  }
}
