package com.kontakt.sdk.android.ble.discovery;

import android.annotation.TargetApi;
import android.bluetooth.le.ScanCallback;
import android.os.Build;

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
public class ScanErrors {

  // Error codes from ScanCallback
  public final static int SCAN_FAILED_ALREADY_STARTED = ScanCallback.SCAN_FAILED_ALREADY_STARTED;
  public final static int SCAN_FAILED_APPLICATION_REGISTRATION_FAILED = ScanCallback.SCAN_FAILED_APPLICATION_REGISTRATION_FAILED;
  public final static int SCAN_FAILED_FEATURE_UNSUPPORTED = ScanCallback.SCAN_FAILED_FEATURE_UNSUPPORTED;
  public final static int SCAN_FAILED_INTERNAL_ERROR = ScanCallback.SCAN_FAILED_INTERNAL_ERROR;

  // Additional custom error codes
  public final static int SCAN_FAILED_BLUETOOTH_ADAPTER_DISABLED = 10;

  public static String getMessage(int errorCode) {
    final String message;
    switch (errorCode) {
      case SCAN_FAILED_ALREADY_STARTED:
        message = "Scan failed - application already started";
        break;
      case SCAN_FAILED_APPLICATION_REGISTRATION_FAILED:
        message = "Scan failed - application registration failed";
        break;
      case SCAN_FAILED_FEATURE_UNSUPPORTED:
        message = "Scan failed - feature unsupported";
        break;
      case SCAN_FAILED_INTERNAL_ERROR:
        message = "Scan failed - internal error";
        break;
      case SCAN_FAILED_BLUETOOTH_ADAPTER_DISABLED:
        message = "Scan failed - bluetooth adapter is disabled";
        break;
      default:
        message = "Scan failed - error code = " + errorCode;
        break;
    }
    return message;
  }

}
