package com.kontakt.sdk.android.ble.connection;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;

public interface GattController {

  boolean connect();

  void close();

  void disconnect();

  void refresh();

  boolean writeCharacteristic(BluetoothGattCharacteristic characteristic);

  boolean writeCharacteristic(BluetoothGattCharacteristic characteristic, boolean readResponse);

  boolean readCharacteristic(BluetoothGattCharacteristic characteristic);

  boolean writeDescriptor(BluetoothGattDescriptor descriptor);

  boolean setCharacteristicNotification(BluetoothGattCharacteristic characteristic, boolean enable);

}
