/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.triggers;

import android.text.TextUtils;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.TriggersService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.model.Trigger;
import com.kontakt.sdk.android.common.model.TriggerContext;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class CreateTriggerRequestExecutor
extends RequestExecutor<Trigger> {
    private final TriggersService triggersService;
    private final Trigger trigger;

    public CreateTriggerRequestExecutor(TriggersService triggersService, Trigger trigger) {
        this.triggersService = triggersService;
        this.trigger = trigger;
    }

    @Override
    public Trigger execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (Trigger)super.execute();
    }

    @Override
    public void execute(CloudCallback<Trigger> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<Trigger> prepareCall() {
        return this.triggersService.create(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.trigger.getName() != null, "Cannot create trigger - specify name");
        SDKPreconditions.checkState(this.trigger.getType() != null, "Cannot create trigger - specify type");
        SDKPreconditions.checkState(this.trigger.getContext() != null, "Cannot create trigger - specify context");
        SDKPreconditions.checkState(this.trigger.getExecutor() != null, "Cannot create trigger - specify executor");
        SDKPreconditions.checkState(this.validTrackingData(), "Cannot create trigger - specify at least one of tracking identifiers (ID, region, namespace).");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", this.trigger.getName());
        params.put("type", this.trigger.getType().name());
        params.put("executor", this.trigger.getExecutor().name());
        if (this.trigger.getContext().getTrackingId() != null) {
            params.put("context.trackingId", this.trigger.getContext().getTrackingId());
        }
        if (this.trigger.getContext().getProximity() != null) {
            params.put("context.proximity", this.trigger.getContext().getProximity().name());
        }
        if (this.trigger.getContext().getSourceId() != null) {
            params.put("context.sourceId", this.trigger.getContext().getSourceId());
        }
        params.putAll(this.regionParams());
        params.putAll(this.namespaceParams());
        return params;
    }

    private boolean validTrackingData() {
        TriggerContext context = this.trigger.getContext();
        UUID proximityUUID = context.getProximityUUID();
        int major = context.getMajor();
        int minor = context.getMinor();
        boolean invalidMajorMinor = major == -1 && minor != -1;
        boolean validRegionData = proximityUUID != null && !invalidMajorMinor;
        String namespace = context.getNamespace();
        boolean validNamespaceData = !TextUtils.isEmpty((CharSequence)namespace);
        String trackingId = context.getTrackingId();
        boolean validTrackingId = !TextUtils.isEmpty((CharSequence)trackingId);
        return validRegionData || validNamespaceData || validTrackingId;
    }

    private Map<String, String> regionParams() {
        boolean validRegionData;
        HashMap<String, String> regionParams = new HashMap<String, String>();
        TriggerContext context = this.trigger.getContext();
        UUID proximityUUID = context.getProximityUUID();
        int major = context.getMajor();
        int minor = context.getMinor();
        boolean invalidMajorMinor = major == -1 && minor != -1;
        boolean bl = validRegionData = proximityUUID != null && !invalidMajorMinor;
        if (validRegionData) {
            regionParams.put("context.proximityUuid", proximityUUID.toString());
            if (major != -1) {
                regionParams.put("context.major", String.valueOf(major));
            }
            if (minor != -1) {
                regionParams.put("context.minor", String.valueOf(minor));
            }
        }
        return regionParams;
    }

    private Map<String, String> namespaceParams() {
        boolean validNamespaceData;
        HashMap<String, String> namespaceParams = new HashMap<String, String>();
        TriggerContext context = this.trigger.getContext();
        String namespace = context.getNamespace();
        String instanceId = context.getInstanceId();
        boolean bl = validNamespaceData = !TextUtils.isEmpty((CharSequence)namespace);
        if (validNamespaceData) {
            namespaceParams.put("context.namespace", namespace);
            if (!TextUtils.isEmpty((CharSequence)instanceId)) {
                namespaceParams.put("context.instanceId", instanceId);
            }
        }
        return namespaceParams;
    }
}

