/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.places;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.PlacesService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.model.Place;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class UpdatePlaceRequestExecutor
extends RequestExecutor<String> {
    private final PlacesService placesService;
    private final UUID id;
    private Place place;

    public UpdatePlaceRequestExecutor(PlacesService placesService, UUID id) {
        this.placesService = placesService;
        this.id = id;
    }

    public UpdatePlaceRequestExecutor with(Place place) {
        SDKPreconditions.checkNotNull(place, "place cannot be null");
        this.place = place;
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.placesService.updatePlace(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.place != null, "cannot update place - specify place data to update");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("placeId", this.id.toString());
        if (this.place.getName() != null) {
            params.put("name", this.place.getName());
        }
        if (this.place.getScale() != 0.0) {
            params.put("scale", String.valueOf(this.place.getScale()));
        }
        if (this.place.getCoordinates() != null) {
            params.put("coordinates", this.place.getCoordinates().toString());
        }
        if (this.place.getSchema() != null) {
            params.put("schema", this.place.getSchema());
        }
        return params;
    }
}

