/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.firmwares;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.FirmwaresService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.Firmware;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

public class FirmwareRequestExecutor
extends RequestExecutor<Firmware> {
    private final FirmwaresService firmwaresService;
    private final String name;
    private DeviceType deviceType;

    public FirmwareRequestExecutor(FirmwaresService firmwaresService, String name) {
        this.firmwaresService = firmwaresService;
        this.name = name;
    }

    public FirmwareRequestExecutor forDeviceType(DeviceType deviceType) {
        SDKPreconditions.checkNotNull(deviceType, "device type cannot be null");
        this.deviceType = deviceType;
        return this;
    }

    @Override
    public Firmware execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (Firmware)super.execute();
    }

    @Override
    public void execute(CloudCallback<Firmware> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.deviceType != null, "cannot get firmware - specify device type");
    }

    @Override
    protected Call<Firmware> prepareCall() {
        return this.firmwaresService.getFirmware(this.name, this.deviceType.name());
    }

    @Override
    protected Map<String, String> params() {
        return new HashMap<String, String>();
    }
}

