/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.cloud.response.paginated.CredentialsList;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.OrderBy;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

public class CredentialsListRequestExecutor
extends PaginatedRequestExecutor<CredentialsList> {
    private final DevicesService devicesService;
    private final List<String> uniqueIds;

    public CredentialsListRequestExecutor(DevicesService devicesService, List<String> uniqueIds) {
        this.devicesService = devicesService;
        this.uniqueIds = uniqueIds;
    }

    @Override
    protected Call<CredentialsList> prepareCall() {
        return this.devicesService.getDeviceCredentialsByUniqueIds(StringUtils.join(this.uniqueIds, ","), this.params());
    }

    @Override
    public CredentialsListRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public CredentialsListRequestExecutor maxResult(int maxResult) {
        super.maxResult(maxResult);
        return this;
    }

    @Override
    public CredentialsListRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public CredentialsListRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public CredentialsListRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    protected Map<String, String> params() {
        return super.params();
    }
}

