/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.configs;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ConfigsService;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.model.Message;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

public class DeletePendingConfigsRequestExecutor
extends RequestExecutor<Message> {
    private final ConfigsService configsService;
    private final String[] uniqueIds;

    public DeletePendingConfigsRequestExecutor(ConfigsService configsService, String ... uniqueIds) {
        this.configsService = configsService;
        this.uniqueIds = uniqueIds;
    }

    public DeletePendingConfigsRequestExecutor(ConfigsService configsService, List<String> uniqueIds) {
        this.configsService = configsService;
        int size = uniqueIds.size();
        this.uniqueIds = uniqueIds.toArray(new String[size]);
    }

    @Override
    protected Call<Message> prepareCall() {
        return this.configsService.deletePendingConfigs(this.params());
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uniqueId", StringUtils.join(this.uniqueIds, ","));
        return params;
    }
}

