package com.kontakt.sdk.android.common.model;

/**
 * Order by provides possible orderings according to which the requested results are returned.
 */
public enum OrderBy {

  /**
   * The CREATION - order by creation date.
   */
  CREATION("created"),

  /**
   * The LAST_UPDATE - order by last update.
   */
  LAST_UPDATE("updated"),

  /**
   * The NAME - order by name.
   */
  NAME("name"),

  /**
   * The UNIQUE_ID - order by unique id.
   */
  UNIQUE_ID("uniqueId"),

  /**
   * The ALIAS - order by alias.
   */
  ALIAS("alias"),

  /**
   * The PROXIMITY - order by proximity.
   */
  PROXIMITY("proximity"),

  /**
   * The MAJOR - order by major.
   */
  MAJOR("major"),

  /**
   * The MINOR - order by minor.
   */
  MINOR("minor"),

  /**
   * The TX_POWER - order by tx power.
   */
  TX_POWER("txPower"),

  /**
   * The FIRST_NAME - order by first name.
   */
  FIRST_NAME("firstName"),

  /**
   * The LAST_NAME - order by last name.
   */
  LAST_NAME("lastName");

  private final String value;

  OrderBy(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }

  public String value() {
    return value;
  }
}
