package com.kontakt.sdk.android.cloud.response;

/**
 * A callback for any asynchronous call to Kontakt.io Proximity REST API that can result in
 * success or failure.
 *
 * @param <T> the response type.
 */
public interface CloudCallback<T> {

  /**
   * Called when an asynchronous call completes successfully.
   *
   * @param response the response object.
   * @param headers the response headers.
   */
  void onSuccess(T response, CloudHeaders headers);

  /**
   * Called when an asynchronous call fails to complete normally.
   *
   * @param error the error object.
   */
  void onError(CloudError error);
}
