package com.kontakt.sdk.android.cloud.api.executor;

import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.CloudError;
import com.kontakt.sdk.android.cloud.response.CloudHeaders;
import com.kontakt.sdk.android.cloud.util.ErrorUtils;
import com.kontakt.sdk.android.common.FileData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class FileDataCallbackWrapper implements Callback<ResponseBody> {

  private final CloudCallback<FileData> callback;

  public FileDataCallbackWrapper(final CloudCallback<FileData> callback) {
    this.callback = callback;
  }

  @Override
  public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
    Map<String, String> headers = new HashMap<>();
    for (String key : response.headers().names()) {
      headers.put(key, response.headers().get(key));
    }
    if (response.isSuccessful()) {
      final ResponseBody body = response.body();
      FileData fileData;
      if (body == null) {
        fileData = FileData.empty();
      } else {
        try {
          fileData = FileData.of(body.bytes());
        } catch (IOException e) {
          fileData = FileData.empty();
        }
      }
      callback.onSuccess(fileData, CloudHeaders.of(headers));
    } else {
      CloudError cloudError = ErrorUtils.parseError(response);
      callback.onError(cloudError);
    }
  }

  @Override
  public void onFailure(Call<ResponseBody> call, Throwable t) {
    CloudError error = new CloudError(null, -1, t.getLocalizedMessage());
    callback.onError(error);
  }
}
