package com.kontakt.sdk.android.cloud;

import com.kontakt.sdk.android.cloud.api.ActionsApi;
import com.kontakt.sdk.android.cloud.api.ActivitiesApi;
import com.kontakt.sdk.android.cloud.api.CommandsApi;
import com.kontakt.sdk.android.cloud.api.ConfigsApi;
import com.kontakt.sdk.android.cloud.api.DevicesApi;
import com.kontakt.sdk.android.cloud.api.EventsApi;
import com.kontakt.sdk.android.cloud.api.FirmwaresApi;
import com.kontakt.sdk.android.cloud.api.ManagersApi;
import com.kontakt.sdk.android.cloud.api.NamespacesApi;
import com.kontakt.sdk.android.cloud.api.PlacesApi;
import com.kontakt.sdk.android.cloud.api.PresetsApi;
import com.kontakt.sdk.android.cloud.api.ProximitiesApi;
import com.kontakt.sdk.android.cloud.api.ReceiversApi;
import com.kontakt.sdk.android.cloud.api.TriggersApi;
import com.kontakt.sdk.android.cloud.api.VenuesApi;

/**
 * API client responsible for interaction with Kontakt.io Proximity REST API.
 *
 * @see <a href="http://docs.kontakt.io/rest-api/quickstart/">Kontakt.io REST API Quick Start Guide</a>
 */
public interface KontaktCloud {

  /**
   * Provides actions API endpoint.
   *
   * @return the actions API.
   */
  ActionsApi actions();

  /**
   * Provides devices API endpoint.
   *
   * @return the devices API.
   */
  DevicesApi devices();

  /**
   * Provides venues API endpoint.
   *
   * @return the venues API.
   */
  VenuesApi venues();

  /**
   * Provides places API endpoint.
   *
   * @return the places API.
   */
  PlacesApi places();

  /**
   * Provides receivers API endpoint.
   *
   * @return the receivers API.
   */
  ReceiversApi receivers();

  /**
   * Provides configs API endpoint.
   *
   * @return the configs API.
   */
  ConfigsApi configs();

  /**
   * Provides managers API endpoint.
   *
   * @return the managers API.
   */
  ManagersApi managers();

  /**
   * Provides firmwares API endpoint.
   *
   * @return the firmwares API.
   */
  FirmwaresApi firmwares();

  /**
   * Provides proximities API endpoint.
   *
   * @return the proximitites API.
   */
  ProximitiesApi proximities();

  /**
   * Provides namespaces API endpoint.
   *
   * @return the namespaces API.
   */
  NamespacesApi namespaces();

  /**
   * Provides commands API endpoint.
   *
   * @return the commands API.
   */
  CommandsApi commands();

  /**
   * Provides events API endpoint.
   *
   * @return the events API.
   */
  EventsApi events();

  /**
   * Provides presets API endpoint.
   *
   * @return the presets API.
   */
  PresetsApi presets();

  /**
   * Provides triggers API endpoint.
   *
   * @return the triggers API.
   */
  TriggersApi triggers();

  /**
   * Provides activities API endpoint.
   *
   * @return the activities API.
   */
  ActivitiesApi activities();
}
