package com.kontakt.sdk.android.ble.spec;

import static com.kontakt.sdk.android.common.util.ConversionUtils.asInt;

public enum TelemetryError {

  NO_INTERNET(0);

  private final int value;

  TelemetryError(int value) {
    this.value = value;
  }

  public int value() {
    return value;
  }

  public static TelemetryError fromValueBytes(final byte[] valueBytes) {
    int value = asInt(new byte[] { 0x0, 0x0, valueBytes[0] , valueBytes[1]});
    for (final TelemetryError error : values()) {
      if ( (1 << (15 - error.value)) == value) return error;
    }
    return null;
  }
}
