package com.kontakt.sdk.android.ble.service;

import android.os.Build;

class ScanCompatFactory {

  static ScanCompat createScanCompat() {
    if (isLollipopOrHigher()) {
      return new ScanCompatL();
    } else {
      return new ScanCompatJB();
    }
  }

  static ScanCompat createScanCompat(boolean shouldBeIntenseScan){
    System.out.println(String.format("ble scan type: isIntense %b", shouldBeIntenseScan));
    return isLowerThanLollipop() ? new ScanCompatJB() : (shouldBeIntenseScan ? new ScanCompatJB() : new ScanCompatL());
  }

  private static boolean isLowerThanLollipop(){
    return Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP;
  }

  private static boolean isLollipopOrHigher() {
    return Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP;
  }
}
