package com.kontakt.sdk.android.ble.service;

import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;

import java.io.IOException;

abstract class ScanCompat {

  public abstract ScanConfiguration createScanConfiguration(ScanContext scanContext, FutureShufflesCache cache, IEventCollector eventCollector);

  public abstract ForceScanScheduler createForceScanScheduler(ScanConfiguration newConfiguration);

  public abstract ScanController createScanController(ScanConfiguration newConfiguration, ForceScanScheduler forceScanScheduler);

  class AbstractScanConfiguration implements ScanConfiguration {

    private final ScanContext scanContext;
    private final BleScanCallback scanCallback;

    AbstractScanConfiguration(final ScanContext scanContext, final BleScanCallback scanCallback) {
      this.scanCallback = scanCallback;
      this.scanContext = scanContext;
    }

    @Override
    public BleScanCallback getScanCallback() {
      return scanCallback;
    }

    @Override
    public void addListener(InternalProximityListener proximityListener) {
      scanCallback.addListener(proximityListener);
    }

    @Override
    public void removeListener(InternalProximityListener proximityListener) {
      scanCallback.removeListener(proximityListener);
    }

    @Override
    public void close() throws IOException {
      scanCallback.close();
    }

    @Override
    public ScanContext getScanContext() {
      return scanContext;
    }
  }

  abstract class AbstractScanConfigurationL extends AbstractScanConfiguration implements ScanConfigurationL {
    AbstractScanConfigurationL(ScanContext scanContext, BleScanCallback scanCallback) {
      super(scanContext, scanCallback);
    }
  }

}
