package com.kontakt.sdk.android.ble.security.property;

import java.io.UnsupportedEncodingException;

public class StringProperty extends AbstractProperty<String> {
  private static final String CHARSET_NAME = "us-ascii";
  private final String value;

  public StringProperty(PropertyID id, String value) {
    super(id);
    this.value = value;
  }

  public StringProperty(PropertyID id, byte[] value) {
    super(id);
    try {
      this.value = new String(value, CHARSET_NAME);
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
  }

  @Override
  public byte[] getBytes() {
    try {
      return value.getBytes(CHARSET_NAME);
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
  }

  @Override
  public byte getSize() {
    return (byte) getBytes().length;
  }

  @Override
  public String getValue() {
    return value;
  }
}
