package com.kontakt.sdk.android.ble.manager.service;

import android.os.RemoteException;
import com.kontakt.sdk.android.ble.connection.OnServiceReadyListener;

/**
 * Service connector interface. This interface is implemented by every
 * object able to connect with the backing service.
 */
public interface ServiceConnector {
  /**
   * Attempts to connect ServiceConnector to backing Service.
   *
   * @param onServiceReadyListener the listener informing that connection
   * ends with success
   * (
   * ).
   * @throws RemoteException thrown in case of connection
   * failure
   */
  void connect(OnServiceReadyListener onServiceReadyListener) throws RemoteException;

  /**
   * Checks whether the connector is connected to backing service.
   *
   * @return the boolean
   */
  boolean isConnected();

  /**
   * Disconnects the connector from backing service.
   */
  void disconnect();
}
