package com.kontakt.sdk.android.ble.discovery;

public enum FrameDataType {

  FLAGS_DATA(0x01),
  IBEACON_MANUFACTURER_SPECIFIC_DATA(0xFF),
  EDDYSTONE_PACKET_SERVICE_DATA(0x16),
  EDDYSTONE_FLAGS(0x01),
  EDDYSTONE_UUID_LIST(0x03),
  SCAN_RESPONSE_SERVICE_DATA(0x16),
  TX_POWER_LEVEL(0x0A),
  LOCAL_NAME(0x09),
  ACCELEROMETER_BEACON_MANUFACTURER_SPECIFIC_DATA(0xFF),
  UNKNOWN(0x0);

  private final int identifier;

  FrameDataType(int identifier) {
    this.identifier = identifier;
  }

  public static FrameDataType fromByte(int input) {
    for (FrameDataType frameDataType : FrameDataType.values()) {
      if (input == frameDataType.getIdentifier()) {
        return frameDataType;
      }
    }
    return UNKNOWN;
  }

  public int getIdentifier() {
    return identifier;
  }

  public boolean isServiceData() {
    return this == EDDYSTONE_PACKET_SERVICE_DATA || this == SCAN_RESPONSE_SERVICE_DATA;
  }

  public boolean isManufacturerSpecificData() {
    return this == IBEACON_MANUFACTURER_SPECIFIC_DATA || this == ACCELEROMETER_BEACON_MANUFACTURER_SPECIFIC_DATA;
  }

}
