/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;

public class Time
implements Parcelable {
    private static final int BLE_TIME_LENGTH = 10;
    public static final Parcelable.Creator<Time> CREATOR = new Parcelable.Creator<Time>(){

        public Time createFromParcel(Parcel source) {
            return new Time(source);
        }

        public Time[] newArray(int size) {
            return new Time[size];
        }
    };
    private final int year;
    private final int month;
    private final int dayOfMonth;
    private final int hour;
    private final int minute;
    private final int second;
    private final int dayOfWeek;

    public static Builder builder() {
        return new Builder();
    }

    public static Time fromBleValue(byte[] value) {
        SDKPreconditions.checkArgument(value.length == 10, "Unexpected frame length. Should be: 10");
        return new Builder().year(ConversionUtils.asInt(ConversionUtils.invert(Arrays.copyOfRange(value, 0, 2)))).month(value[2]).dayOfMonth(value[3]).hour(value[4]).minute(value[5]).second(value[6]).dayOfWeek(value[7]).build();
    }

    public static Time getCurrentUTC() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int dayOfMonth = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int calendarDayOfWeek = calendar.get(7) - 1;
        int dayOfWeek = calendarDayOfWeek == 0 ? 7 : calendarDayOfWeek;
        return new Builder().year(year).month(month).dayOfMonth(dayOfMonth).hour(hour).minute(minute).second(second).dayOfWeek(dayOfWeek).build();
    }

    protected Time(Parcel in) {
        this.hour = in.readInt();
        this.minute = in.readInt();
        this.second = in.readInt();
        this.dayOfWeek = in.readInt();
        this.dayOfMonth = in.readInt();
        this.month = in.readInt();
        this.year = in.readInt();
    }

    private Time() {
        this(new Builder());
    }

    Time(Builder builder) {
        this.hour = builder.hour;
        this.minute = builder.minute;
        this.second = builder.second;
        this.dayOfWeek = builder.dayOfWeek;
        this.dayOfMonth = builder.dayOfMonth;
        this.month = builder.month;
        this.year = builder.year;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public byte[] toBleValue() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        buffer.put(ConversionUtils.to2ByteArray(this.year));
        buffer.put((byte)this.month);
        buffer.put((byte)this.dayOfMonth);
        buffer.put((byte)this.hour);
        buffer.put((byte)this.minute);
        buffer.put((byte)this.second);
        buffer.put((byte)this.dayOfWeek);
        return buffer.array();
    }

    public String toString() {
        return "Time{hour=" + this.hour + ", minute=" + this.minute + ", second=" + this.second + ", dayOfWeek=" + this.dayOfWeek + ", dayOfMonth=" + this.dayOfMonth + ", month=" + this.month + ", year=" + this.year + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Time time = (Time)o;
        if (this.hour != time.hour) {
            return false;
        }
        if (this.minute != time.minute) {
            return false;
        }
        if (this.second != time.second) {
            return false;
        }
        if (this.dayOfWeek != time.dayOfWeek) {
            return false;
        }
        if (this.dayOfMonth != time.dayOfMonth) {
            return false;
        }
        if (this.month != time.month) {
            return false;
        }
        return this.year == time.year;
    }

    public int hashCode() {
        int result = this.hour;
        result = 31 * result + this.minute;
        result = 31 * result + this.second;
        result = 31 * result + this.dayOfWeek;
        result = 31 * result + this.dayOfMonth;
        result = 31 * result + this.month;
        result = 31 * result + this.year;
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.hour);
        dest.writeInt(this.minute);
        dest.writeInt(this.second);
        dest.writeInt(this.dayOfWeek);
        dest.writeInt(this.dayOfMonth);
        dest.writeInt(this.month);
        dest.writeInt(this.year);
    }

    public static class Builder {
        int hour;
        int minute;
        int second;
        int dayOfWeek;
        int dayOfMonth;
        int month;
        int year;

        public Builder hour(int hour) {
            this.hour = hour;
            return this;
        }

        public Builder minute(int minute) {
            this.minute = minute;
            return this;
        }

        public Builder second(int second) {
            this.second = second;
            return this;
        }

        public Builder dayOfWeek(int dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public Builder dayOfMonth(int dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public Builder month(int month) {
            this.month = month;
            return this;
        }

        public Builder year(int year) {
            this.year = year;
            return this;
        }

        public Time build() {
            return new Time(this);
        }
    }
}

