/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;

public class FirmwareVersion
implements Comparable<FirmwareVersion>,
Parcelable {
    public static final Parcelable.Creator<FirmwareVersion> CREATOR = new Parcelable.Creator<FirmwareVersion>(){

        public FirmwareVersion createFromParcel(Parcel source) {
            return new FirmwareVersion(source);
        }

        public FirmwareVersion[] newArray(int size) {
            return new FirmwareVersion[size];
        }
    };
    private final String version;

    public FirmwareVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Version can not be null");
        }
        if (!version.matches("[0-9]+(\\.[0-9]+)*")) {
            throw new IllegalArgumentException("Invalid version format");
        }
        this.version = version;
    }

    protected FirmwareVersion(Parcel in) {
        this.version = in.readString();
    }

    public final String get() {
        return this.version;
    }

    public boolean isGreaterThan(FirmwareVersion other) {
        return this.compareTo(other) == 1;
    }

    public boolean isGreaterOrEqualTo(FirmwareVersion other) {
        return this.isGreaterThan(other) || this.isEqualTo(other);
    }

    public boolean isLowerThan(FirmwareVersion other) {
        return this.compareTo(other) == -1;
    }

    public boolean isLowerOrEqualTo(FirmwareVersion other) {
        return this.isLowerThan(other) || this.isEqualTo(other);
    }

    public boolean isEqualTo(FirmwareVersion other) {
        return this.compareTo(other) == 0;
    }

    public String toString() {
        return this.version;
    }

    @Override
    public int compareTo(FirmwareVersion that) {
        String[] thisParts = this.get().split("\\.");
        String[] thatParts = that.get().split("\\.");
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
            int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((FirmwareVersion)that) == 0;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.version);
    }
}

