/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.venues;

import android.util.Base64;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.VenuesService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.model.Venue;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

public class CreateVenueRequestExecutor
extends RequestExecutor<Venue> {
    private final VenuesService venuesService;
    private final Venue venue;
    private String imageFile;

    public CreateVenueRequestExecutor(VenuesService venuesService, Venue venue) {
        this.venuesService = venuesService;
        this.venue = venue;
    }

    public CreateVenueRequestExecutor withImageFile(File file) throws IOException {
        SDKPreconditions.checkNotNull(file, "file is null");
        SDKPreconditions.checkState(file.exists(), "file does not exist");
        byte[] bytes = ConversionUtils.convert(file);
        this.imageFile = Base64.encodeToString((byte[])bytes, (int)0);
        return this;
    }

    public CreateVenueRequestExecutor withImageFile(byte[] bytes) throws IOException {
        SDKPreconditions.checkNotNull(bytes, "bytes cannot be null");
        this.imageFile = Base64.encodeToString((byte[])bytes, (int)0);
        return this;
    }

    @Override
    public Venue execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (Venue)super.execute();
    }

    @Override
    public void execute(CloudCallback<Venue> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<Venue> prepareCall() {
        return this.venuesService.createVenue(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.venue.getName() != null, "cannot create venue - specify name");
        SDKPreconditions.checkState(this.venue.getDescription() != null, "cannot create venue - specify description");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", this.venue.getName());
        params.put("description", this.venue.getDescription());
        if (this.imageFile != null) {
            params.put("file", this.imageFile);
        }
        if (this.venue.getLatitude() != null) {
            params.put("lat", this.venue.getLatitude());
        }
        if (this.venue.getLongitude() != null) {
            params.put("lng", this.venue.getLongitude());
        }
        return params;
    }
}

