/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.firmwares;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.FirmwaresService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

public class UnscheduleFirmwareUpdateRequestExecutor
extends RequestExecutor<String> {
    private final FirmwaresService firmwaresService;
    private String[] deviceUniqueIds;

    public UnscheduleFirmwareUpdateRequestExecutor(FirmwaresService firmwaresService) {
        this.firmwaresService = firmwaresService;
    }

    public UnscheduleFirmwareUpdateRequestExecutor forDevices(String ... deviceUniqueIds) {
        this.deviceUniqueIds = SDKPreconditions.checkNotNull(deviceUniqueIds, "IDs cannot be null");
        return this;
    }

    public UnscheduleFirmwareUpdateRequestExecutor forDevices(List<String> deviceUniqueIds) {
        SDKPreconditions.checkNotNull(deviceUniqueIds, "IDs cannot be null");
        int size = deviceUniqueIds.size();
        this.deviceUniqueIds = deviceUniqueIds.toArray(new String[size]);
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.firmwaresService.unscheduleFirmwareUpdate(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.deviceUniqueIds != null, "specify devices");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uniqueId", StringUtils.join(this.deviceUniqueIds, ","));
        return params;
    }
}

