/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.actions;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActionsService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.paginated.Actions;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

public class ActionsRequestExecutor
extends PaginatedRequestExecutor<Actions> {
    private final ActionsService actionsService;
    private String[] uniqueIds;

    public ActionsRequestExecutor(ActionsService actionsService) {
        this.actionsService = actionsService;
    }

    public ActionsRequestExecutor forDevices(String ... uniqueIds) {
        this.uniqueIds = SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return this;
    }

    public ActionsRequestExecutor forDevices(List<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        int size = uniqueIds.size();
        this.uniqueIds = uniqueIds.toArray(new String[size]);
        return this;
    }

    @Override
    public ActionsRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public ActionsRequestExecutor maxResult(int maxResult) {
        super.startIndex(maxResult);
        return this;
    }

    @Override
    public ActionsRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public ActionsRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public ActionsRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    public Actions execute() throws IOException, KontaktCloudException {
        SDKPreconditions.checkState(this.uniqueIds != null, "Cannot get actions - specify devices");
        return (Actions)super.execute();
    }

    @Override
    public void execute(CloudCallback<Actions> callback) {
        SDKPreconditions.checkState(this.uniqueIds != null, "Cannot get actions - specify devices");
        super.execute(callback);
    }

    @Override
    protected Call<Actions> prepareCall() {
        Call<Actions> call = this.eTag != null ? this.actionsService.getActions(this.params(), this.eTag) : this.actionsService.getActions(this.params());
        return call;
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        if (this.uniqueIds != null) {
            params.put("uniqueId", StringUtils.join(this.uniqueIds, ","));
        }
        return params;
    }
}

