/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor;

import com.kontakt.sdk.android.cloud.api.executor.FileDataCallbackWrapper;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.FileData;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class FileRequestExecutor {
    public FileData execute() throws IOException, KontaktCloudException {
        Call<ResponseBody> call = this.prepareCall();
        Response response = call.execute();
        if (response.isSuccessful()) {
            ResponseBody body = (ResponseBody)response.body();
            if (body == null) {
                return FileData.empty();
            }
            return FileData.of(body.bytes());
        }
        String rawMessage = response.raw().message();
        int code = response.code();
        String message = "code - " + code + ", message - " + rawMessage;
        throw new KontaktCloudException(message, code);
    }

    public void execute(CloudCallback<FileData> callback) {
        Call<ResponseBody> call = this.prepareCall();
        call.enqueue((Callback)new FileDataCallbackWrapper(callback));
    }

    protected abstract Call<ResponseBody> prepareCall();
}

