/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.secure_profile;

import com.kontakt.sdk.android.ble.device.SecureProfile;
import com.kontakt.sdk.android.ble.discovery.FramePayload;
import com.kontakt.sdk.android.ble.discovery.secure_profile.KontaktTLMResolver;
import com.kontakt.sdk.android.ble.discovery.secure_profile.PayloadResolver;
import com.kontakt.sdk.android.ble.spec.KontaktTelemetry;

public class TelemetryPayloadResolver
extends PayloadResolver {
    private static final byte PAYLOAD_IDENTIFIER = 3;
    private static final KontaktTLMResolver KONTAKT_TLM_RESOLVER = new KontaktTLMResolver();

    public TelemetryPayloadResolver() {
        super((byte)3);
    }

    @Override
    public void resolve(FramePayload payload) {
        if (payload == null) {
            return;
        }
        String macAddress = payload.getAddress();
        String name = this.getName(payload);
        byte[] serviceData = this.getServiceData(payload);
        KontaktTelemetry telemetry = KONTAKT_TLM_RESOLVER.parse(serviceData);
        SecureProfile secureProfile = new SecureProfile.Builder().macAddress(macAddress).name(name).telemetry(telemetry).shuffled(false).build();
        this.onPayloadResolved(secureProfile);
    }
}

