/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.secure_profile;

import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.device.SecureProfile;
import com.kontakt.sdk.android.ble.discovery.FramePayload;
import com.kontakt.sdk.android.ble.discovery.ShuffledSecureProfileResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.InstanceIdResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.NamespaceIdResolver;
import com.kontakt.sdk.android.ble.discovery.secure_profile.PayloadResolver;
import com.kontakt.sdk.android.common.model.Model;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import java.util.Locale;

public class ShuffledDevicePayloadResolver
extends PayloadResolver
implements ShuffledSecureProfileResolver.ResolveCallback {
    private static final byte PAYLOAD_IDENTIFIER = 1;
    private final ShuffledSecureProfileResolver shuffleResolver;
    private static final NamespaceIdResolver NAMESPACE_RESOLVER = new NamespaceIdResolver(8);
    private static final InstanceIdResolver INSTANCE_ID_RESOLVER = new InstanceIdResolver(18);

    public ShuffledDevicePayloadResolver(FutureShufflesCache shufflesCache) {
        super((byte)1);
        this.shuffleResolver = new ShuffledSecureProfileResolver(this, shufflesCache);
    }

    ShuffledDevicePayloadResolver(ShuffledSecureProfileResolver shuffleResolver) {
        super((byte)1);
        this.shuffleResolver = shuffleResolver;
    }

    @Override
    public void resolve(FramePayload payload) {
        if (payload == null) {
            return;
        }
        String macAddress = payload.getAddress();
        String name = this.getName(payload);
        byte[] serviceData = this.getServiceData(payload);
        Model model = Model.fromCode(serviceData[3]);
        String firmware = this.parseFirmwareVersion(serviceData);
        byte batteryLevel = serviceData[6];
        byte txPower = serviceData[7];
        String namespace = this.parseNamespace(serviceData);
        String shuffledInstanceId = this.parseShuffledInstanceId(serviceData);
        SecureProfile secureProfile = new SecureProfile.Builder().macAddress(macAddress).name(name).model(model).firmwareRevision(firmware).batteryLevel(batteryLevel).txPower(txPower).namespace(namespace).instanceId(shuffledInstanceId).shuffled(true).build();
        this.shuffleResolver.resolve(secureProfile);
    }

    private String parseFirmwareVersion(byte[] serviceData) {
        byte firmwareVersionMajor = serviceData[4];
        byte firmwareVersionMinor = serviceData[5];
        if (firmwareVersionMajor < 0 || firmwareVersionMinor < 0) {
            return "";
        }
        return String.format(Locale.getDefault(), "%d.%d", (int)firmwareVersionMajor, (int)firmwareVersionMinor);
    }

    private String parseNamespace(byte[] serviceData) {
        return NAMESPACE_RESOLVER.parse(serviceData);
    }

    private String parseShuffledInstanceId(byte[] serviceData) {
        return INSTANCE_ID_RESOLVER.parse(serviceData);
    }

    void handleLostEvent(ISecureProfile profile) {
        this.shuffleResolver.onDeviceLost(profile);
    }

    void disableShuffleResolver() {
        this.shuffleResolver.disable();
    }

    @Override
    public void onResolved(ISecureProfile profile) {
        this.onPayloadResolved(new SecureProfile.Builder(profile).build());
    }
}

