/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.secure_profile;

import com.kontakt.sdk.android.ble.discovery.PropertyResolver;
import com.kontakt.sdk.android.ble.spec.Acceleration;
import com.kontakt.sdk.android.ble.spec.DeviceDataLoggerStatus;
import com.kontakt.sdk.android.ble.spec.KontaktTelemetry;
import com.kontakt.sdk.android.ble.spec.TelemetryError;
import com.kontakt.sdk.android.common.util.ConversionUtils;

final class KontaktTLMResolver
implements PropertyResolver<KontaktTelemetry> {
    private static final byte BASIC_SYSTEM_HEALTH_IDENTIFIER = 1;
    private static final byte ACCELEROMETER_IDENTIFIER = 2;
    private static final byte SCANNING_IDENTIFIER = 3;
    private static final byte MORE_SYSTEM_HEALTH_IDENTIFIER = 4;
    private static final byte SENSORS_IDENTIFIER = 5;
    private static final byte LIGHT_LEVEL_IDENTIFIER = 10;
    private static final byte TEMPERATURE_IDENTIFIER = 11;
    private static final byte BUTTON_CLICK_IDENTIFIER = 13;
    private static final byte IDENTIFIED_BUTTON_CLICK_IDENTIFIER = 17;
    private static final byte DATA_LOGGER_STATUS_IDENTIFIER = 16;
    private static final byte HUMIDITY_IDENTIFIER = 18;
    private static final byte TEMPERATURE_16_BIT_IDENTIFIER = 19;
    private static final byte BLE_CHANNEL_IDENTIFIER = 20;
    private static final int BASIC_SYSTEM_HEALTH_FIELD_LENGTH = 6;
    private static final int ACCELEROMETER_FIELD_LENGTH = 9;
    private static final int SCANNING_FIELD_LENGTH = 5;
    private static final int MORE_SYSTEM_HEALTH_FIELD_LENGTH = 10;
    private static final int SENSORS_FIELD_LENGTH = 3;
    private static final int LIGHT_LEVEL_FIELD_LENGTH = 2;
    private static final int TEMPERATURE_FIELD_LENGTH = 2;
    private static final int BUTTON_CLICK_FIELD_LENGTH = 3;
    private static final int IDENTIFIED_BUTTON_CLICK_FIELD_LENGTH = 4;
    private static final int DATA_LOGGER_STATUS_FIELD_LENGTH = 2;
    private static final int HUMIDITY_FIELD_LENGTH = 2;
    private static final int TEMPERATURE_16_BIT_FIELD_LENGTH = 3;
    private static final int BLE_CHANNEL_FIELD_LENGTH = 2;
    private static final int FIELDS_PAYLOAD_OFFSET = 3;

    KontaktTLMResolver() {
    }

    @Override
    public KontaktTelemetry parse(byte[] packet) {
        int fieldLength;
        byte[] field;
        if (packet == null || packet.length == 0) {
            return null;
        }
        KontaktTelemetry.Builder builder = new KontaktTelemetry.Builder();
        byte[] fieldsData = ConversionUtils.extractSubdata(packet, 3, packet.length - 3);
        while (fieldsData != null && fieldsData.length > 0 && (field = ConversionUtils.extractSubdata(fieldsData, 1, fieldLength = ConversionUtils.asInt(fieldsData[0]))) != null) {
            byte identifier = field[0];
            if (identifier == 1 && field.length >= 6) {
                this.resolveBasicSystemHealth(builder, field);
            }
            if (identifier == 2 && field.length >= 9) {
                this.resolveAccelerometerData(builder, field);
            }
            if (identifier == 3 && field.length >= 5) {
                this.resolveScanningData(builder, field);
            }
            if (identifier == 4 && field.length >= 10) {
                this.resolveMoreSystemHealth(builder, field);
            }
            if (identifier == 5 && field.length >= 3) {
                this.resolveSensors(builder, field);
            }
            if (identifier == 10 && field.length >= 2) {
                this.resolveLightLevel(builder, field);
            }
            if (identifier == 11 && field.length >= 2) {
                this.resolveTemperature(builder, field);
            }
            if (identifier == 13 && field.length >= 3) {
                this.resolveButtonClick(builder, field);
            }
            if (identifier == 17 && field.length >= 4) {
                this.resolveIdentifiedButtonClick(builder, field);
            }
            if (identifier == 16 && field.length >= 2) {
                this.resolveDataLoggerStatus(builder, field);
            }
            if (identifier == 18 && field.length >= 2) {
                this.resolveHumidity(builder, field);
            }
            if (identifier == 19 && field.length >= 3) {
                this.resolveTemperature16Bit(builder, field);
            }
            if (identifier == 20 && field.length >= 2) {
                this.resolveBleChannel(builder, field);
            }
            fieldsData = ConversionUtils.extractSubdata(fieldsData, field.length + 1, fieldsData.length - (field.length + 1));
        }
        return builder.build();
    }

    private void resolveBasicSystemHealth(KontaktTelemetry.Builder builder, byte[] field) {
        int timestamp = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 4));
        builder.timestamp(timestamp);
        int batteryLevel = ConversionUtils.asInt(field[5]);
        builder.batteryLevel(batteryLevel);
    }

    private void resolveAccelerometerData(KontaktTelemetry.Builder builder, byte[] field) {
        int sensitivity = ConversionUtils.asInt(field[1]);
        builder.sensitivity(sensitivity);
        Acceleration acceleration = new Acceleration(ConversionUtils.extractSubdata(field, 2, 3));
        builder.acceleration(acceleration);
        int lastDoubleTap = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 5, 2));
        builder.lastDoubleTap(lastDoubleTap);
        int lastThreshold = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 7, 2));
        builder.lastThreshold(lastThreshold);
    }

    private void resolveScanningData(KontaktTelemetry.Builder builder, byte[] field) {
        int bleScans = ConversionUtils.asInt(field[1]);
        builder.bleScans(bleScans);
        int wifiScans = ConversionUtils.asInt(field[2]);
        builder.wifiScans(wifiScans);
        int bleDevices = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 3, 2));
        builder.bleDevices(bleDevices);
    }

    private void resolveMoreSystemHealth(KontaktTelemetry.Builder builder, byte[] field) {
        int timestamp = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 4));
        builder.timestamp(timestamp);
        int uptime = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 5, 2));
        builder.uptime(uptime);
        int systemLoad = ConversionUtils.asInt(field[7]);
        builder.systemLoad(systemLoad);
        TelemetryError error = TelemetryError.fromValue(ConversionUtils.asInt(ConversionUtils.extractSubdata(field, 8, 2)));
        builder.error(error);
    }

    private void resolveSensors(KontaktTelemetry.Builder builder, byte[] field) {
        int lightSensor = ConversionUtils.asInt(field[1]);
        builder.lightSensor(lightSensor);
        byte temperature = field[2];
        builder.temperature(temperature);
    }

    private void resolveLightLevel(KontaktTelemetry.Builder builder, byte[] field) {
        int light = ConversionUtils.asInt(field[1]);
        builder.lightSensor(light);
    }

    private void resolveTemperature(KontaktTelemetry.Builder builder, byte[] field) {
        int temperature = ConversionUtils.asInt(field[1]);
        builder.temperature(temperature);
    }

    private void resolveButtonClick(KontaktTelemetry.Builder builder, byte[] field) {
        int singleClick = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 2));
        builder.lastSingleClick(singleClick < 65535 ? singleClick : 0);
    }

    private void resolveIdentifiedButtonClick(KontaktTelemetry.Builder builder, byte[] field) {
        int clickCount = ConversionUtils.asInt(field[1]);
        builder.singleClickCount(clickCount);
        int singleClick = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 2, 2));
        builder.lastSingleClick(singleClick < 65535 ? singleClick : 0);
    }

    private void resolveDataLoggerStatus(KontaktTelemetry.Builder builder, byte[] field) {
        int loggingStatus = ConversionUtils.asInt(field[1]);
        builder.dataLoggerStatus(loggingStatus == 1 ? DeviceDataLoggerStatus.ENABLED : DeviceDataLoggerStatus.DISABLED);
    }

    private void resolveHumidity(KontaktTelemetry.Builder builder, byte[] field) {
        int humidity = ConversionUtils.asInt(field[1]);
        builder.humidity(humidity);
    }

    private void resolveTemperature16Bit(KontaktTelemetry.Builder builder, byte[] field) {
        int temperature = ConversionUtils.asIntFromLittleEndianBytes(ConversionUtils.extractSubdata(field, 1, 2));
        builder.temperature(temperature / 256);
    }

    private void resolveBleChannel(KontaktTelemetry.Builder builder, byte[] field) {
        int bleChannel = ConversionUtils.asInt(field[1]);
        builder.bleChannel(bleChannel);
    }
}

