package com.kontakt.sdk.android.common.model;

/**
 * Kontakt.io subscription plan enumeration
 */
public enum SubscriptionPlan {
  NONE,
  LEGACY,
  NOT_APPLICABLE,
  FREE,
  MANAGEMENT,
  FLEET_MANAGEMENT,
  LOCATION_ENGINE;

  public static SubscriptionPlan fromString(String planString) {
    for (SubscriptionPlan plan : SubscriptionPlan.values()) {
      if (plan.name().equalsIgnoreCase(planString)) {
        return plan;
      }
    }
    return NONE;
  }
}
