package com.kontakt.sdk.android.common.model;

/**
 * Enumeration type of device model.
 */
public enum Model {

  /**
   * Smart Beacon device model.
   */
  SMART_BEACON(1, "SB16-2"),

  /**
   * Smart Beacon 3 device model.
   */
  SMART_BEACON_3(9, "SB18-3"),

  /**
   * Smart Beacon with Humidity Sensor device model.
   */
  SMART_BEACON_3H(13, "SB18-3H"),

  /**
   * USB Beacon device model.
   */
  USB_BEACON(3, "UB16-2"),

  /**
   * Card Beacon device model.
   */
  CARD_BEACON(4, "CT16-2"),

  /**
   * Card Beacon 2 device model
   */
  CARD_BEACON_2(11, "CT18-3"),

  /**
   * Gateway device model.
   */
  GATEWAY(5, "GW16-2"),

  /**
   * Beacon PRO device model.
   */
  BEACON_PRO(6, "BP16-3"),

  /**
   * PROBE device model.
   */
  PROBE(7, ""),

  /**
   * Tag Beacon device model.
   */
  TAG_BEACON(8, "S18-3"),

  /**
   * Coin Tag device model.
   */
  COIN_TAG(12, "C18-3"),

  /**
   * Heavy Duty Beacon device model.
   */
  HEAVY_DUTY_BEACON(10, "HD18-3"),

  /**
   * Tough Beacon 2 device model.
   */
  TOUGH_BEACON_2(14, "TB18-2"),

  /**
   * Bracelet Tag device model.
   */
  BRACELET_TAG(15, "BT18-3"),

  /**
   * Bracelet Tag 2 device model.
   */
  BRACELET_TAG_2(17, "BT19-4"),

  /**
   * Universal Tag device model.
   */
  UNIVERSAL_TAG(16, "UT19-1"),

  /**
   * Sensor Beacon device model.
   */
  SENSOR_BEACON(-1, ""),

  /**
   * Cloud Beacon device model.
   */
  CLOUD_BEACON(-1, "GW14-1"),

  /**
   * External device model.
   */
  EXTERNAL(-1, ""),

  UNKNOWN(-1, "");

  private final int code;
  private final String productName;

  Model(final int code, final String productName) {
    this.code = code;
    this.productName = productName;
  }

  public int getCode() {
    return code;
  }

  public String getProductName() {
    return productName;
  }

  public static Model fromString(String modelString) {
    if (modelString != null) {
      for (Model model : Model.values()) {
        if (modelString.equalsIgnoreCase(model.name())) {
          return model;
        }
      }
    }
    return SMART_BEACON;
  }

  public static Model fromCode(int code) {
    if (code <= 0) {
      return UNKNOWN;
    }
    for (Model model : Model.values()) {
      if (model.getCode() == code) {
        return model;
      }
    }
    return UNKNOWN;
  }
}
