package com.kontakt.sdk.android.common.model;

import android.os.Parcel;

/**
 * Model class that provides information about location's coordinates.
 */
public class LocationCoordinates implements Coordinates {

  /**
   * Parcelable CREATOR constant.
   */
  public static final Creator<LocationCoordinates> CREATOR = new Creator<LocationCoordinates>() {
    @Override
    public LocationCoordinates createFromParcel(Parcel source) {
      return new LocationCoordinates(source);
    }

    @Override
    public LocationCoordinates[] newArray(int size) {
      return new LocationCoordinates[size];
    }
  };

  private final double x;
  private final double y;
  private final double z;

  public LocationCoordinates(double x, double y, double z) {
    this.x = x;
    this.y = y;
    this.z = z;
  }

  protected LocationCoordinates(Parcel in) {
    this.x = in.readDouble();
    this.y = in.readDouble();
    this.z = in.readDouble();
  }

  public double getX() {
    return x;
  }

  public double getY() {
    return y;
  }

  public double getZ() {
    return z;
  }

  @Override
  public Type getType() {
    return Type.LOCATION;
  }

  @Override
  public String toString() {
    return x + ":" + y + ":" + z;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    LocationCoordinates that = (LocationCoordinates) o;

    if (Double.compare(that.x, x) != 0) return false;
    if (Double.compare(that.y, y) != 0) return false;
    return Double.compare(that.z, z) == 0;
  }

  @Override
  public int hashCode() {
    int result;
    long temp;
    temp = Double.doubleToLongBits(x);
    result = (int) (temp ^ (temp >>> 32));
    temp = Double.doubleToLongBits(y);
    result = 31 * result + (int) (temp ^ (temp >>> 32));
    temp = Double.doubleToLongBits(z);
    result = 31 * result + (int) (temp ^ (temp >>> 32));
    return result;
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(Parcel dest, int flags) {
    dest.writeDouble(this.x);
    dest.writeDouble(this.y);
    dest.writeDouble(this.z);
  }
}
