package com.kontakt.sdk.android.cloud.api.service;

import com.kontakt.sdk.android.ble.spec.Telemetry;
import com.kontakt.sdk.android.cloud.response.paginated.Configs;
import com.kontakt.sdk.android.cloud.response.paginated.CredentialsList;
import com.kontakt.sdk.android.cloud.response.paginated.Devices;
import com.kontakt.sdk.android.common.model.Device;

import java.util.Map;

import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;
import retrofit2.http.Url;

public interface DevicesService {

  @GET("/device")
  Call<Devices> getDevices(@QueryMap Map<String, String> params);

  @GET("/device")
  Call<Devices> getDevices(@QueryMap Map<String, String> params, @Header("If-None-Match") String eTag);

  @GET
  Call<Devices> getDevicesFromUrl(@Url String url);

  @GET
  Call<Devices> getDevicesFromUrl(@Url String url, @Header("If-None-Match") String eTag);

  @GET("/device/unassigned/{managerId}")
  Call<Devices> getUnassignedDevices(@Path("managerId") String managerId, @QueryMap Map<String, String> params);

  @GET("/device/unassigned/{managerId}")
  Call<Devices> getUnassignedDevices(@Path("managerId") String managerId, @QueryMap Map<String, String> params, @Header("If-None-Match") String eTag);

  @GET("/device/credentials")
  Call<CredentialsList> getDeviceCredentials(@Query("uniqueId") String uniqueId);

  @GET("/device/credentials")
  Call<CredentialsList> getDeviceCredentialsByUniqueIds(@Query("uniqueId") String uniqueIds, @QueryMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/device/update")
  Call<String> updateDevice(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/device/update")
  Call<Configs> applySecureConfigs(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/device/assign")
  Call<String> assignDevice(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/device/unassign")
  Call<String> unassignDevice(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/device/move")
  Call<String> moveDevice(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/device/share")
  Call<String> shareDevices(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/device/unshare")
  Call<String> unshareDevices(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/device/register")
  Call<Device> registerDevice(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/eddystone")
  Call<Telemetry> decryptTelemetry(@FieldMap() Map<String, String> params);

}
