package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.events.CollectEventsRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.EventsService;
import com.kontakt.sdk.android.common.model.EventPacket;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

/**
 * An abstract representation of Events API endpoint. Provides executors that can be
 * used to handle all event-related requests.
 */
public class EventsApi {

  private final EventsService eventsService;

  /**
   * Constructs Events API endpoint initialized with corresponding service class.
   *
   * @param eventsService the events API service.
   */
  public EventsApi(EventsService eventsService) {
    this.eventsService = eventsService;
  }

  /**
   * Provides executor that can be used to collect events.
   *
   * @param eventPacket the event packet.
   * @param uniqueId device uniqueId. Can be null if not necessary.
   * @return the request executor.
   */
  public CollectEventsRequestExecutor collect(final EventPacket eventPacket, final String uniqueId) {
    SDKPreconditions.checkNotNull(eventPacket, "event packet cannot be null");
    return new CollectEventsRequestExecutor(eventsService, eventPacket, uniqueId);
  }
}
