package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.os.Build;

import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;

@TargetApi(Build.VERSION_CODES.JELLY_BEAN_MR2)
final class ScanCompatJB extends ScanCompat {

  public ScanConfiguration createScanConfiguration(ScanContext scanContext, FutureShufflesCache cache, IEventCollector eventCollector) {
    final BleScanCallback scanCallback = MonitorCallback.create(scanContext, cache, eventCollector);
    return new AbstractScanConfiguration(scanContext, scanCallback) {
    };
  }

  public ScanController createScanController(ScanConfiguration configuration, ForceScanScheduler forceScanScheduler) {
    return new ScanController.Builder().setScanActiveRunner(Runners.newRunner(Runners.RunnerType.MONITOR_ACTIVE_RUNNER, configuration))
        .setScanPassiveRunner(Runners.newRunner(Runners.RunnerType.MONITOR_PASSIVE_RUNNER, configuration))
        .setScanPeriod(configuration.getScanContext().getScanPeriod())
        .setForceScanScheduler(forceScanScheduler)
        .build();
  }

  public ForceScanScheduler createForceScanScheduler(final ScanConfiguration configuration) {
    final ScanContext scanContext = configuration.getScanContext();

    if (scanContext.getForceScanConfiguration() == ForceScanConfiguration.DISABLED) {
      return ForceScanScheduler.DISABLED;
    }
    return new ForceScanScheduler(Runners.newRunner(Runners.RunnerType.FORCE_SCAN_RUNNER, configuration));
  }

}
