package com.kontakt.sdk.android.ble.security.parser;

import com.kontakt.sdk.android.ble.security.property.AbstractProperty;
import com.kontakt.sdk.android.ble.security.property.ByteArrayProperty;
import java.nio.ByteBuffer;
import java.util.UUID;

import static com.kontakt.sdk.android.common.util.SDKPreconditions.checkState;

public class PropertyHelper {
  public static UUID readUUID(AbstractProperty<?> property) {
    checkState(property instanceof ByteArrayProperty);
    ByteBuffer buf = ByteBuffer.wrap(property.getBytes());
    long hi = buf.getLong();
    long lo = buf.getLong();
    return new UUID(hi, lo);
  }

  public static int readInt8(AbstractProperty<?> property) {
    return property.getBytes()[0];
  }

  public static int readInt16(AbstractProperty<?> property) {
    int val = (Short) property.getValue();
    return val < 0 ? val + (1 << 16) : val;
  }

  public static String readString(AbstractProperty<?> property) {
    return (String) property.getValue();
  }

  public static int readUInt32(AbstractProperty<?> property) {
    return ((Number) property.getValue()).intValue();
  }
}
