package com.kontakt.sdk.android.ble.security;

import android.util.Base64;
import java.nio.ByteBuffer;

public abstract class Packet {
  public static final byte PROTOCOL_VERSION = 0x00;
  private static final int TOKEN_SIZE = 4;
  private final Flag flag;
  private final Operation operation;
  protected final int token;

  protected Packet(Flag flag, Operation operation, int token) {
    this.flag = flag;
    this.operation = operation;
    this.token = Integer.reverseBytes(token);
  }

  public byte[] getData() {
    ByteBuffer buf = ByteBuffer.allocate(256);
    buf.put(PROTOCOL_VERSION);
    buf.put(flag.getValue());
    buf.put(operation.getValue());
    byte[] payload = getPayload();
    buf.putShort(Short.reverseBytes((short) (payload.length + TOKEN_SIZE))); //Integer.BYTES - token length
    buf.putInt(token);
    buf.put(payload);
    int position = buf.position();
    buf.position(0);
    byte[] result = new byte[position];
    buf.get(result);
    return result;
  }

  public String getBase64Data() {
    byte[] data = getData();
    return Base64.encodeToString(data, Base64.DEFAULT);
  }

  protected abstract byte[] getPayload();
}
