package com.kontakt.sdk.android.ble.manager.listeners;

import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import java.util.List;

/**
 * Listener used to report iBeacon scanning results.
 */
public interface IBeaconListener {

  /**
   * Called when iBeacon is discovered for the first time. This will be called only once per scan or after beacon is reported lost.
   *
   * @param iBeacon {@link IBeaconDevice} instance.
   * @param region {@link IBeaconRegion} instance.
   */
  void onIBeaconDiscovered(IBeaconDevice iBeacon, IBeaconRegion region);

  /**
   * Called when iBeacons are updated.
   *
   * @param iBeacons List of updated {@link IBeaconDevice} devices.
   * @param region {@link IBeaconRegion} instance.
   */
  void onIBeaconsUpdated(List<IBeaconDevice> iBeacons, IBeaconRegion region);

  /**
   * Called when iBeacon is reported lost (out of range). onIBeaconDiscovered will be called when beacon is back in range.
   *
   * @param iBeacon Lost {@link IBeaconDevice} instance.
   * @param region {@link IBeaconRegion} instance.
   */
  void onIBeaconLost(IBeaconDevice iBeacon, IBeaconRegion region);
}
