package com.kontakt.sdk.android.ble.filter.ibeacon;

import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

/**
 * A predicate accepting iBeacon device with specific device name.
 */
public final class DeviceNameFilter implements IBeaconFilter {

  private final String name;

  public DeviceNameFilter(final String name) {
    SDKPreconditions.checkNotNull(name, "Device name is null or empty");
    this.name = name;
  }

  @Override
  public boolean apply(IBeaconDevice target) {
    return name.equals(target.getName());
  }

  /**
   * Gets device name.
   *
   * @return the device name
   */
  public String getDeviceName() {
    return name;
  }
}