package com.kontakt.sdk.android.ble.discovery;

import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

/**
 * Utility methods for bluetooth devices discovery.
 */
public final class DiscoveryUtils {

  private DiscoveryUtils() {
  }

  /**
   * Calculates distance from remote device.
   *
   * @param txPower the tx power
   * @param rssi    the rssi
   * @param profile device profile
   * @return the double
   * @see <a href="http://stackoverflow.com/questions/20416218/understanding-ibeacon-distancing" target="_blank">Stack Overflow answer</a>
   */
  public static double calculateDistance(int txPower, double rssi, DeviceProfile profile) {
    SDKPreconditions.checkNotNull(profile, "Profile can't be null");

    if (rssi == 0) {
      return -1.0;
    }

    int normalizedTxPower = (profile == DeviceProfile.EDDYSTONE ? txPower - 41 : txPower);
    double ratio = rssi * 1.0 / normalizedTxPower;
    if (ratio < 1.0) {
      return Math.pow(ratio, 10);
    } else {
      return (0.89976) * Math.pow(ratio, 7.7095) + 0.111;
    }
  }

}
