package com.kontakt.sdk.android.ble.dfu;

/**
 * Enum representing single Kontakt DFU response.
 */
enum KDFUResponse {

  /**
   * Indicates successful operation.
   */
  SUCCESS((byte) 0x00),

  /**
   * Indicates recoverable error. Retrying operation may yield success. (retrying Transaction or Activation).
   */
  FAILURE((byte) 0x01),

  /**
   * Indicates fatal, unrecoverable error. Erasing whole image may help.
   */
  FATAL((byte) 0x02),

  /**
   * {@link KDFUCommand#ACTIVATE} Response code. Received image checksum was invalid.
   */
  IMAGE_CHECKSUM_INVALID((byte) 0x03),

  /**
   * {@link KDFUCommand#ACTIVATE} Response code. Received image size was invalid.
   */
  IMAGE_SIZE_INVALID((byte) 0x04),

  /**
   * {@link KDFUCommand#ACTIVATE} Response code. Received image header has incorrect format.
   */
  IMAGE_HEADER_INVALID((byte) 0x05),

  /**
   * This response is received if invalid command is sent to DFU service.
   */
  INVALID_STATE((byte) 0x06);

  private final byte code;

  public static KDFUResponse fromCode(byte code) {
    for (KDFUResponse response : KDFUResponse.values()) {
      if (response.getCode() == code) {
        return response;
      }
    }
    return null;
  }

  KDFUResponse(byte code) {
    this.code = code;
  }

  public byte getCode() {
    return code;
  }
}
