package com.kontakt.sdk.android.ble.cache;

import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SecureProfileUtils;

class SecureProfileResolveRequest {
  private final ISecureProfile fakeDevice;
  private ResolverType resolvedBy = ResolverType.NONE;
  private ResolveRequestStatus status;

  public SecureProfileResolveRequest(ISecureProfile secureProfile) {
    this.fakeDevice = secureProfile;
  }

  static SecureProfileResolveRequest of(RemoteBluetoothDevice device) {
    ISecureProfile secureProfile = SecureProfileUtils.fromRemoteBluetoothDevice(device);
    return new SecureProfileResolveRequest(secureProfile);
  }

  public ISecureProfile getFakeDevice() {
    return fakeDevice;
  }

  public ResolverType getResolvedBy() {
    return resolvedBy;
  }

  public void setResolvedBy(ResolverType resolvedBy) {
    this.resolvedBy = resolvedBy;
  }

  public void setStatus(ResolveRequestStatus status) {
    this.status = status;
  }

  public ResolveRequestStatus getStatus() {
    return status;
  }

  @Override
  public boolean equals(Object o) {
    if (o == null || !(o instanceof SecureProfileResolveRequest)) {
      return false;
    }

    if (o == this) {
      return true;
    }

    SecureProfileResolveRequest resolveRequest = (SecureProfileResolveRequest) o;
    return SDKEqualsBuilder.start().equals(fakeDevice, resolveRequest.fakeDevice).equals(resolvedBy, resolveRequest.resolvedBy).result();
  }

  @Override
  public int hashCode() {
    return HashCodeBuilder.init().append(fakeDevice).append(resolvedBy).build();
  }
}
