/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.ActivityContext;
import com.kontakt.sdk.android.common.model.ActivityType;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Activity
implements Parcelable {
    public static final Parcelable.Creator<Activity> CREATOR = new Parcelable.Creator<Activity>(){

        public Activity createFromParcel(Parcel source) {
            return new Activity(source);
        }

        public Activity[] newArray(int size) {
            return new Activity[size];
        }
    };
    private final String name;
    private final ActivityContext context;
    private final List<UUID> triggerId;
    private final UUID id;
    private final ActivityType type;

    public static Builder builder() {
        return new Builder();
    }

    Activity(Builder builder) {
        this.name = builder.name;
        this.context = builder.context;
        this.triggerId = builder.triggerId;
        this.id = builder.id;
        this.type = builder.type;
    }

    protected Activity(Parcel in) {
        this.name = in.readString();
        this.context = (ActivityContext)in.readParcelable(ActivityContext.class.getClassLoader());
        this.triggerId = new ArrayList<UUID>();
        in.readList(this.triggerId, UUID.class.getClassLoader());
        this.id = (UUID)in.readSerializable();
        int tmpType = in.readInt();
        this.type = tmpType == -1 ? null : ActivityType.values()[tmpType];
    }

    private Activity() {
        this(new Builder());
    }

    public String getName() {
        return this.name;
    }

    public ActivityContext getContext() {
        return this.context;
    }

    public List<UUID> getTriggerIds() {
        return this.triggerId;
    }

    public UUID getId() {
        return this.id;
    }

    public ActivityType getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Activity)) {
            return false;
        }
        Activity trigger = (Activity)object;
        return SDKEqualsBuilder.start().equals(this.id, trigger.id).equals(this.name, trigger.name).equals((Object)this.type, (Object)trigger.type).equals(this.context, trigger.context).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.id).append(this.name).append((Object)this.type).append(this.context).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeParcelable((Parcelable)this.context, flags);
        dest.writeList(this.triggerId);
        dest.writeSerializable((Serializable)this.id);
        dest.writeInt(this.type == null ? -1 : this.type.ordinal());
    }

    public static class Builder {
        String name;
        ActivityContext context;
        List<UUID> triggerId;
        UUID id;
        ActivityType type;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder context(ActivityContext context) {
            this.context = context;
            return this;
        }

        public Builder triggerIds(List<UUID> triggerIds) {
            this.triggerId = triggerIds;
            return this;
        }

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder type(ActivityType type) {
            this.type = type;
            return this;
        }

        public Activity build() {
            return new Activity(this);
        }
    }
}

