/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.actions;

import com.kontakt.sdk.android.cloud.api.executor.actions.CreateActionRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActionsService;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.Action;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;
import java.util.Map;

public class CreateBrowserActionRequestExecutor
extends CreateActionRequestExecutor {
    private String url;

    public CreateBrowserActionRequestExecutor(ActionsService actionsService) {
        super(actionsService);
        this.actionType = Action.Type.BROWSER;
    }

    public CreateBrowserActionRequestExecutor withUrl(String url) {
        SDKPreconditions.checkNotNullOrEmpty(url, "Url cannot be null or empty");
        this.url = url;
        return this;
    }

    @Override
    public CreateBrowserActionRequestExecutor forDevices(String ... uniqueIds) {
        super.forDevices(uniqueIds);
        return this;
    }

    @Override
    public CreateBrowserActionRequestExecutor forDevices(List<String> uniqueIds) {
        super.forDevices(uniqueIds);
        return this;
    }

    @Override
    public CreateBrowserActionRequestExecutor withProximity(Proximity proximity) {
        super.withProximity(proximity);
        return this;
    }

    @Override
    protected void checkPreconditions() {
        SDKPreconditions.checkState(this.uniqueIds != null, "Cannot create action - specify devices");
        SDKPreconditions.checkState(this.actionType != null, "Cannot create action - specify action type");
        SDKPreconditions.checkState(this.proximity != null, "Cannot create action - specify proximity");
        SDKPreconditions.checkState(this.url != null, "Cannot create action - specify url");
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        params.put("url", this.url);
        return params;
    }
}

