/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanSettings;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.service.MonitorCallbackL;
import com.kontakt.sdk.android.ble.service.Runners;
import com.kontakt.sdk.android.ble.service.ScanConfiguration;
import com.kontakt.sdk.android.ble.service.ScanConfigurationL;
import com.kontakt.sdk.android.common.log.Logger;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

final class RunnersL {
    private RunnersL() {
    }

    static Runnable newRunner(Runners.RunnerType runnerType, ScanConfiguration configuration) {
        switch (runnerType) {
            case MONITOR_ACTIVE_RUNNER: {
                return RunnersL.newMonitorActiveRunnerL((ScanConfigurationL)configuration);
            }
            case MONITOR_PASSIVE_RUNNER: {
                return RunnersL.newMonitorPassiveRunnerL((ScanConfigurationL)configuration);
            }
            case FORCE_SCAN_RUNNER: {
                return RunnersL.newForceScanRunnerL((ScanConfigurationL)configuration);
            }
        }
        throw new IllegalArgumentException("Invalid runner type passed");
    }

    private static Runnable newMonitorPassiveRunnerL(ScanConfigurationL configuration) {
        final MonitorCallbackL monitorCallback = (MonitorCallbackL)configuration.getScanCallback();
        return new Runnable(){

            @Override
            @TargetApi(value=21)
            public void run() {
                BluetoothLeScanner scanner = RunnersL.getScanner(monitorCallback);
                if (scanner == null) {
                    return;
                }
                Logger.d("Stopping scan");
                scanner.stopScan((ScanCallback)monitorCallback);
                Logger.d("On monitor stopped");
                monitorCallback.onMonitorStopped();
            }
        };
    }

    private static Runnable newMonitorActiveRunnerL(ScanConfigurationL configuration) {
        final MonitorCallbackL monitorCallback = (MonitorCallbackL)configuration.getScanCallback();
        final ScanSettings scanSettings = configuration.getScanSettings();
        final ArrayList scanFilterList = new ArrayList();
        return new Runnable(){

            @Override
            @TargetApi(value=21)
            public void run() {
                BluetoothLeScanner scanner = RunnersL.getScanner(monitorCallback);
                if (scanner == null) {
                    return;
                }
                Logger.d("Start Scan");
                scanner.startScan(scanFilterList, scanSettings, (ScanCallback)monitorCallback);
                Logger.d("On Monitor started");
                monitorCallback.onMonitorStarted();
            }
        };
    }

    private static Runnable newForceScanRunnerL(ScanConfigurationL configuration) {
        final MonitorCallbackL monitorCallback = (MonitorCallbackL)configuration.getScanCallback();
        final ScanSettings scanSettings = configuration.getScanSettings();
        ForceScanConfiguration forceScanConfiguration = configuration.getScanContext().getForceScanConfiguration();
        final long forceScanActivePeriod = forceScanConfiguration.getForceScanActivePeriod();
        final long forceScanPassivePeriod = forceScanConfiguration.getForceScanPassivePeriod();
        final ArrayList scanFilterList = new ArrayList();
        return new Runnable(){

            @Override
            @TargetApi(value=21)
            public void run() {
                BluetoothLeScanner scanner = RunnersL.getScanner(monitorCallback);
                if (scanner == null) {
                    return;
                }
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        Logger.d("Stopping Scan (force)");
                        scanner.stopScan((ScanCallback)monitorCallback);
                        Logger.d(String.format("Sleep during passive period: %s", String.valueOf(forceScanPassivePeriod)));
                        TimeUnit.MILLISECONDS.sleep(forceScanPassivePeriod);
                        Logger.d("Starting scan (force)");
                        scanner.startScan(scanFilterList, scanSettings, (ScanCallback)monitorCallback);
                        Logger.d(String.format("Sleep during active period: %s", String.valueOf(forceScanActivePeriod)));
                        TimeUnit.MILLISECONDS.sleep(forceScanActivePeriod);
                    }
                    scanner.stopScan((ScanCallback)monitorCallback);
                    Logger.d("Force scan finished");
                }
                catch (InterruptedException e) {
                    scanner.stopScan((ScanCallback)monitorCallback);
                    Logger.d("Force scan interrupted");
                }
            }
        };
    }

    @TargetApi(value=21)
    static BluetoothLeScanner getScanner(MonitorCallbackL monitorCallback) {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            BluetoothLeScanner bluetoothLeScanner = adapter.getBluetoothLeScanner();
            if (bluetoothLeScanner == null) {
                if (adapter.isEnabled()) {
                    monitorCallback.onScanFailed(3);
                } else {
                    monitorCallback.onScanFailed(10);
                }
            }
            return bluetoothLeScanner;
        }
        monitorCallback.onScanFailed(4);
        return null;
    }
}

