/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.security.parser;

import com.kontakt.sdk.android.ble.security.CRCModbus;
import com.kontakt.sdk.android.ble.security.Flag;
import com.kontakt.sdk.android.ble.security.Operation;
import com.kontakt.sdk.android.ble.security.PayloadEncrypter;
import com.kontakt.sdk.android.ble.security.ResponseCode;
import com.kontakt.sdk.android.ble.security.exception.InvalidCRCException;
import com.kontakt.sdk.android.ble.security.exception.InvalidConfigException;
import com.kontakt.sdk.android.ble.security.exception.InvalidFlagException;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.nio.ByteBuffer;

public class SimpleResponseParser {
    private static final int TOKEN_LENGTH = 4;
    private static final int RESULT_LENGTH = 1;
    private static final int IV_LENGTH = 16;
    private static final int CRC_LENGTH = 2;
    protected byte[] data;
    protected ResponseCode result;
    protected int token;
    protected Flag flag;
    protected Operation operation;
    private final String password;

    public static SimpleResponseParser of(byte[] response) throws InvalidConfigException {
        return new SimpleResponseParser(response, null);
    }

    public static SimpleResponseParser of(byte[] response, String password) throws InvalidConfigException {
        return new SimpleResponseParser(response, password);
    }

    protected SimpleResponseParser(byte[] response, String password) throws InvalidConfigException {
        this.password = password;
        this.extract(response);
    }

    private void extract(byte[] response) throws InvalidConfigException {
        ByteBuffer buffer = ByteBuffer.wrap(response);
        SDKPreconditions.checkState(buffer.get() == 0, "Invalid protocol revision");
        this.flag = Flag.of(buffer.get());
        this.operation = Operation.of(buffer.get());
        switch (this.flag) {
            case ENCRYPTED: {
                this.extractEncrypted(buffer);
                break;
            }
            case NONE: {
                this.extractPlaintext(buffer);
                break;
            }
            default: {
                throw new InvalidFlagException(this.flag, Flag.ENCRYPTED, Flag.NONE);
            }
        }
    }

    private void extractPlaintext(ByteBuffer buffer) {
        short payloadLength = Short.reverseBytes(buffer.getShort());
        this.token = buffer.getInt();
        this.result = ResponseCode.of(buffer.get());
        int dataLength = payloadLength - 4 - 1;
        this.data = new byte[dataLength];
        buffer.get(this.data);
    }

    private void extractEncrypted(ByteBuffer buffer) throws InvalidCRCException {
        SDKPreconditions.checkNotNullOrEmpty(this.password, "password is null");
        short payloadLength = Short.reverseBytes(buffer.getShort());
        this.token = buffer.getInt();
        byte[] iv = ByteBuffer.allocate(16).putInt(this.token).putInt(buffer.getInt()).putLong(buffer.getLong()).array();
        int dataLength = payloadLength - 16 - 2;
        byte[] encryptedPayload = new byte[dataLength];
        buffer.get(encryptedPayload);
        byte[] decoded = new PayloadEncrypter(this.password, iv).decrypt(encryptedPayload);
        byte[] crc = new byte[2];
        buffer.get(crc);
        CRCModbus.assertCorrect(decoded, crc);
        ByteBuffer decodedBuffer = ByteBuffer.wrap(decoded);
        this.result = ResponseCode.of(decodedBuffer.get());
        this.data = new byte[decodedBuffer.remaining()];
        decodedBuffer.get(this.data);
    }

    public ResponseCode getResult() {
        return this.result;
    }

    public int getToken() {
        return Integer.reverseBytes(this.token);
    }

    public Operation getOperation() {
        return this.operation;
    }
}

