/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.security;

import com.kontakt.sdk.android.ble.security.Flag;
import com.kontakt.sdk.android.ble.security.Operation;
import com.kontakt.sdk.android.ble.security.Packet;
import com.kontakt.sdk.android.ble.security.property.AbstractProperty;
import com.kontakt.sdk.android.ble.security.property.TerminatingProperty;
import java.nio.ByteBuffer;
import java.util.List;

public class WriteRequest
extends Packet {
    public static final byte PADDING_BYTE = -91;
    private static final int DESCRIPTOR_LENGTH = 3;
    private List<AbstractProperty<?>> properties;

    public WriteRequest(int token, List<AbstractProperty<?>> properties) {
        super(Flag.REQUEST, Operation.WRITE, token);
        this.properties = properties;
    }

    protected WriteRequest(int token, Flag flag, List<AbstractProperty<?>> properties) {
        super(flag, Operation.WRITE, token);
        this.properties = properties;
    }

    @Override
    protected byte[] getPayload() {
        int length = 0;
        for (AbstractProperty<?> property : this.properties) {
            length = (short)(length + 3);
            length = (short)(length + property.getSize());
        }
        length = (short)(length + 3);
        ByteBuffer buffer = ByteBuffer.allocate(length);
        for (AbstractProperty<?> property : this.properties) {
            buffer.put(property.getData());
        }
        buffer.put(new TerminatingProperty().getData());
        return buffer.array();
    }
}

