/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery;

import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.device.SecureProfile;
import com.kontakt.sdk.android.common.model.ResolvedId;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class ShuffledSecureProfileResolver {
    private final FutureShufflesCache cache;
    private final ResolveCallback callback;

    public ShuffledSecureProfileResolver(ResolveCallback resolveCallback, FutureShufflesCache cache) {
        this.callback = SDKPreconditions.checkNotNull(resolveCallback);
        this.cache = SDKPreconditions.checkNotNull(cache);
        this.cache.addCallback(resolveCallback);
    }

    public void resolve(ISecureProfile originalDevice) {
        if (originalDevice == null) {
            return;
        }
        if (!originalDevice.isShuffled()) {
            this.callback.onResolved(originalDevice);
            return;
        }
        ResolvedId resolvedId = this.cache.get(originalDevice);
        if (resolvedId == null) {
            this.cache.addResolveRequest(originalDevice);
            return;
        }
        if (FutureShufflesCache.PHANTOM_ENTRY.equals(resolvedId)) {
            return;
        }
        if (originalDevice.getUniqueId() == null) {
            ISecureProfile resolvedDevice = this.createUpdatedDevice(originalDevice, resolvedId);
            this.callback.onResolved(resolvedDevice);
        } else {
            this.callback.onResolved(originalDevice);
        }
    }

    public void onDeviceLost(ISecureProfile secureProfile) {
        ResolvedId resolvedId = this.cache.get(secureProfile);
        if (resolvedId == null) {
            this.cache.markIgnored(secureProfile);
        }
    }

    public void disable() {
        this.cache.finishResolveRunners();
    }

    private ISecureProfile createUpdatedDevice(ISecureProfile secureProfile, ResolvedId resolvedId) {
        return new SecureProfile.Builder(secureProfile).resolvedId(resolvedId).build();
    }

    public static interface ResolveCallback {
        public void onResolved(ISecureProfile var1);
    }
}

